class WebsiteNavigation {
    constructor() {
        this.init();
    }

    init() {
        this.events();
    }

    events() {
        this.openWebsiteNavigation();
        this.addBlankPage();
        this.removeWNError();
        this.openTooltip();
        this.closeTooltipOnClick();
        this.openSubTooltip();
        this.backToMainTooltip();
        this.addMenuItemFromOptions();
        this.addCustomLinkMenuItem();
        this.searchMenuItem();
        this.clearSearch();
        this.tooltipContent();
        this.removeMenuItem();
        this.closeOnOtherSidebarsOpen();
    }

    openWebsiteNavigation() {
        let self = this;
        jQuery(document).on('click', '.twbb_editor_nav_menu', function () {
            analyticsDataPush('Website structure', 'Manage Navigation button click', 'Top bar');
            self.websiteNavigationOpenFunctions(jQuery(this));
        });
    }

    websiteNavigationOpenFunctions(that) {
        twbb_trigger_website_navigation_button(that);

        this.changePageStatusOnSave();
        jQuery('.twbb-website-nav-sidebar-content').scroll(() => {
            twbb_close_tooltip();
        });
    }

    addBlankPage() {
        jQuery(document).on('click', '.twbb-wn-add-blank-page', () => {
            const template = jQuery('#elementor-preview-iframe').contents().find('#twbb_new_blank_page-template').html();
            jQuery('body').append(template);
        });
    }

    removeWNError() {
        jQuery(document).on('transitionend', '.twbb-navmenu-sidebar-error', function () {
            jQuery(this).remove();
            if (!jQuery('.twbb-navmenu-sidebar-error').length) {
                jQuery('.twbb-website-nav-sidebar-content').removeClass('twbb-navmenu-sidebar-with-error');
            }
        });
    }

    openTooltip() {
        jQuery(document).on('click', '.twbb-wn-tooltip-parent', function (e) {
            e.stopPropagation();
            if (!jQuery(e.target).hasClass('twbb-wn-tooltip-parent')) return;

            twbb_close_tooltip();
            let top = jQuery(this).offset().top + jQuery(this).outerHeight() + 10,
                left = jQuery(this).offset().left;

            if (jQuery(this).hasClass('twbb-empty-nav-tooltip-container')) {
                top = jQuery(this).offset().top;
                left = jQuery(this).offset().left + jQuery(this).outerWidth() + 10;
            }

            if (jQuery(this).hasClass('wn-add-menu-item')) {
                const template = jQuery('#twbb-wn-add-menu-item-action-tooltip').html();
                if (!jQuery(this).find('.wn-add-menu-item-action-tooltip').length) {
                    jQuery(this).append(template);
                }
                jQuery('.twbb-wn-secondary-container').hide();
                jQuery('.wn-action-tooltip-container.twbb-wn-main-container').show();
            }

            const thisTooltip = jQuery(this).find('.wn-action-tooltip');
            jQuery(this).addClass('twbb-opacity-1');
            thisTooltip.css({ top: `${top}px`, left: `${left}px`, display: 'block' });
            jQuery(this).addClass('twbb_active');
        });
    }

    closeTooltipOnClick() {
        jQuery(document).on('click', (e) => {
            if (!jQuery(e.target).closest('.twbb-wn-tooltip-parent').length) {
                twbb_close_tooltip();
            }
        });
    }

    openSubTooltip() {
        jQuery(document).on('click', '.twbb-wn-main-container .twbb-wn-action-tooltip-item', function (e) {
            e.stopPropagation();
            twbb_renderSubActionTooltip(jQuery(this));
        });
    }

    backToMainTooltip() {
        jQuery(document).on('click', '.twbb-wn-back-add-to-menu-button', function (e) {
            e.stopPropagation();
            jQuery(this).closest('.twbb-wn-secondary-container').hide();
            jQuery('.wn-action-tooltip-container.twbb-wn-main-container').show();
        });
    }

    addMenuItemFromOptions() {
        jQuery(document).on('click', '.twbb-wn-secondary-container .twbb-wn-action-tooltip-item', function (e) {
            e.stopPropagation();
            if (jQuery('.twbb-website-nav-sidebar-container').hasClass('disable-ajax-in-progress')) return;

            const menuId = jQuery('#nav_menu_items').data('nav_id');
            navMenuActions.addMenuItem(menuId, jQuery(this), twbb_addNavSuccessCallback);
        });
    }

    searchMenuItem() {
        jQuery(document).on('input', '.twbb-wn-search', function () {
            twbb_search_init(jQuery(this));
        });
    }

    clearSearch() {
        jQuery(document).on('click', '.twbb-wn-clear-search', function () {
            const searchWrapper = jQuery(this).closest('.twbb-wn-search-wrapper');
            searchWrapper.find('.twbb-wn-search').val('');
            const tooltipContainer = jQuery(this).closest('.wn-action-tooltip-container');
            tooltipContainer.find('.twbb-wn-action-tooltip-item').show();
            tooltipContainer.find('.twbb-wn-search-noresult').hide();
        });
    }

    tooltipContent() {
        jQuery(document)
            .on('mouseenter', '.twbb-tooltip-parent-container-item', function (e) {
                if (!jQuery(e.target).hasClass('twbb-tooltip-parent-container-item')) {
                    return;
                }
                const text = jQuery(this).attr('data-tooltip-text'),
                    top = jQuery(this).offset().top + jQuery(this).outerHeight() + 10,
                    left = jQuery(this).offset().left;
                jQuery('.twbb-tooltip-parent-container .twbb-tooltip').text(text);
                jQuery('.twbb-tooltip-parent-container').css({ top: `${top}px`, left: `${left}px`, display: 'block' });
            })
            .on('mouseleave', '.twbb-tooltip-parent-container-item', () => {
                jQuery('.twbb-tooltip-parent-container').hide();
            });
    }

    removeMenuItem() {
        jQuery(document).on('click', '.twbb-wn-action-remove', function () {
            if (jQuery('.twbb-website-nav-sidebar-container').hasClass('disable-ajax-in-progress')) return;

            const item = jQuery(this).closest('.twbb-website-nav-sidebar-item'),
                navMenu = jQuery('#nav_menu_items'),
                children = item.childMenuItems();

            navMenuActions.removeMenuItem(item, twbb_removeNavMenuItemCallback);

            if (children.length) {
                children.shiftDepthClass(-1);
                navMenuActions.bulkEditMenu(children, navMenu.attr('data-nav_id'));
            }
        });
    }

    addCustomLinkMenuItem() {
        jQuery(document).on('click', '.twbb-wn-add-custom-menu-item-button', function () {
            if (jQuery(this).hasClass('disabled')) return;

            const parent = jQuery(this).closest('.twbb-wn-secondary-container'),
                urlInput = parent.find('#wn-custom-link-nav-url').val(),
                menuId = jQuery('#nav_menu_items').data('nav_id');

            if (urlInput !== '') {
                navMenuActions.addMenuItem(menuId, jQuery(this), twbb_addNavSuccessCallback);
            }
            //empty inputs
            parent.find('#wn-custom-link-nav-label').val('');
            parent.find('#wn-custom-link-nav-url').val('');
        });
    }

    closeOnOtherSidebarsOpen() {
        window.$e.commands.on('run:before', function (component, command, args) {
            if ( 'panel/global/open' === command ) {
                twbb_animate_web_nav_sidebar(0);
            }
        });
        jQuery(document).on('click', '.twbb-theme-customize-close, .twbb-sg-header-button-container, .twbb-customize-button, header button[value="document-settings"]', () => {
            twbb_animate_web_nav_sidebar(0);
        });
    }

    changePageStatusOnSave() {
        const document_id = elementor.config.document.id;
        const document_status = elementor.config.document.status.value;
        const nav_item = jQuery(`.twbb-wn-item[data-id=${document_id}]`);
        if( document_status === 'publish' ) {
            nav_item.attr('data-status', 'publish');
            jQuery(`.twbb-wn-item[data-id=${document_id}] .twbb-wn-status`).text('');
        } else {
            nav_item.attr('data-status', 'draft');
            jQuery(`.twbb-wn-item[data-id=${document_id}] .twbb-wn-status`).text('Draft');
        }
        elementor.saver.on('save', function (args) {
            if (args.status === 'publish' ) {
                nav_item.attr('data-status', 'publish')
                jQuery(`.twbb-wn-item[data-id=${document_id}] .twbb-wn-status`).text('');
            }
        });
    }
}

jQuery(document).ready(function() {
    new WebsiteNavigation();
})
function twbb_trigger_website_navigation_button(element) {
    if( element.hasClass('disabled') ) {
        return;
    }
    //close the invisible backdrop from elementor
    jQuery('.MuiBackdrop-invisible').trigger('click');
    element.addClass('selected');
    const header_add_element_button = jQuery('.MuiToolbar-root .MuiBox-root .MuiGrid-root:first-child .MuiStack-root:eq(1) .MuiBox-root:first-child button');
    header_add_element_button.removeClass('Mui-selected');
    //open website navigation
    if ( !jQuery('.twbb-website-nav-sidebar-container').length ) {
        let website_navigation_sidebar = jQuery('#twbb-navmenu-sidebar-template').html();
        jQuery('#elementor-editor-wrapper-v2').append(website_navigation_sidebar);
        navMenuSortable();
    }
    twbb_animate_web_nav_sidebar(1);
    //add template for adding pages just for saving time
    let template = jQuery("#twbb-wn-add-menu-item-action-tooltip").html();
    if( !jQuery('.wn-add-menu-item-action-tooltip').length ) {
        jQuery('.twbb-website-nav-sidebar-navigation-header .twbb-wn-add-item.wn-add-menu-item').append(template);
    }
}

function twbb_animate_web_nav_sidebar(open) {
    if (open) {
        jQuery('.twbb-website-nav-sidebar-container').removeClass('hide').addClass('show');

        setTimeout(function() {
            let windowWidth = jQuery(window).width();
            let iframeWidth = windowWidth - 380;
            let elementor_panel = jQuery("#elementor-panel").width();
            jQuery("#elementor-preview").css({
                "width": `${iframeWidth}px`,
                "margin-left": 380 - `${parseInt(elementor_panel)}px`,
            });
            jQuery("body").addClass('twbb-website-navigation-sidebar-opened');
            if( typeof twbb_options.smart_scale_option !== "undefined" && twbb_options.smart_scale_option === 'active' ) {
                twbbIframeScale(1, 380);
            } else {
                twbbIframeScale(0);
                jQuery('#elementor-preview').css('margin-left','100px');
            }
            jQuery("#elementor-editor-wrapper").addClass('twbb-animate-sidebar-open');
        }, 100);
    } else {
        twbb_close_website_navigation();
        setTimeout(function() {
            jQuery("#elementor-editor-wrapper").removeClass('twbb-animate-sidebar-open');
        },500);

        jQuery("#elementor-preview").removeAttr("style");
        /* do not scale when option is deactive */
        if( typeof twbb_options.smart_scale_option !== "undefined" && twbb_options.smart_scale_option === 'active' ) {
            twbbIframeScale(1);
        } else {
            twbbIframeScale(0);
        }
        jQuery("body").removeClass('twbb-website-navigation-sidebar-opened');

    }
}

function twbb_close_website_navigation() {
    jQuery('.MuiButtonBase-root[aria-label="Add Element"]').addClass('Mui-selected');
    jQuery('.twbb-website-nav-sidebar-container').removeClass('show').addClass('hide');
}

function twbb_web_nav_sidebar_error_close(error) {
    jQuery(`.${error}`).addClass('remove-animation');
}

function twbb_renderSubActionTooltip(element) {
    let post_type = element.data('post-type'),
        type = element.data('type'),
        action_element = element.closest('.wn-add-menu-item-action-tooltip').find(`.wn-action-tooltip-container[data-post-type="${post_type}"]`),
        html_title = element.text();
    if( post_type !== 'custom' && !action_element.length ) {
        jQuery.ajax({
            url: twbb_website_nav.ajaxurl,
            type: 'POST',
            data: {
                action: 'wn_get_available_menu_items',
                post_type: post_type,
                type: type,
                html_title: html_title,
                nav_menu_id: jQuery('#nav_menu_items').data('nav_id'),
                nonce: twbb_website_nav.nonce,
            },
        })
        .done( (data) => {
            if (data.success) {
                let template = data.data.content;
                element.closest('.wn-add-menu-item-action-tooltip').append(template);
            }
        });
    }
    jQuery('.twbb-wn-main-container').css('display', 'none');
    action_element.css('display', 'block');
}

/*
    * Functionality for different case after Add menu item to nav menu
 */
function twbb_addNavSuccessCallback(data, ui, remove= true) {
    let nav_menu = jQuery("#nav_menu_items");
    ui.find('.twbb-wn-add-item-to-page').css('background-image', 'none');
    ui.find('.twbb-wn-add-item-to-page').append('<i class="fas fa-check"></i>');
    nav_menu.append(data);
    nav_menu.sortable('refresh');
    //if this item data-object is page remove the item from pages sortable too
    if( ui.data('object') === 'page' ) {
        jQuery(`#pages_items .twbb-wn-item[data-id="${ui.data('id')}"]`).remove();
        jQuery('#pages_items').sortable('refresh');
    } else {
        //check if count only itself
        if( ui.closest('.twbb-wn-action-tooltip-items').children('.twbb-wn-action-tooltip-item').length === 1 ) {
            jQuery(`.twbb-wn-main-container .twbb-wn-action-tooltip-item[data-post-type="${ui.data('post_type')}"]`).addClass('twbb-wn-item-not-available');
        }
    }
    //add the item to nav menu sortable
    if( remove ) {
        //remove item after 1 sec
        setTimeout(function () {
            jQuery('.twbb-wn-action-tooltip-items').find(`.twbb-wn-action-tooltip-item[data-id=${ui.attr('data-id')}]`).remove();
        }, 500);
    }
    jQuery('.twbb-wn-add-menu-item-blue-button').css('display','none');
    jQuery('.twbb-website-nav-sidebar-navigation-header .twbb-wn-add-item.wn-add-menu-item.twbb-wn-tooltip-parent').removeClass('twbb-wn-not-visible');
    twbb_updateMenuItemPositions(nav_menu);
    navMenuActions.updateOrdering();
    analyticsDataPush('Website structure', 'Navigation menu edit', 'Left menu');
}

function twbb_removeNavMenuItemCallback(ui) {
    let nav_menu = jQuery("#nav_menu_items"), pages = jQuery('#pages_items'), data_object = ui.attr('data-object'),
    specific_type_collections = jQuery(`.twbb-wn-type-${data_object}`);
    if( data_object === 'page' ) {
        ui.updateDepthClass(0);
        pages.prepend(ui);
        pages.sortable('refresh');
    } else {
        specific_type_collections = jQuery(`.twbb-wn-action-tooltip-item[data-post-type="${ui.attr('data-object')}"]`);
        let specific_type_collections_secondary_containers = jQuery(`.wn-action-tooltip-container.twbb-wn-secondary-container[data-post-type="${data_object}"]`);
        let tooltip_ui = `<div class="twbb-wn-action-tooltip-item twbb-wn-flex-space-between"
            data-type="${ui.attr('data-type')}" data-post_type="${data_object}"
            data-id="${ui.attr('data-id')}" data-title="${ui.attr('data-title')}"
            data-object="${data_object}" data-url="${ui.attr('data-url')}">
                <span>${ui.attr('data-title')}</span><span class="twbb-wn-add-item-to-page"></span></div>`;
        if( specific_type_collections.length  && specific_type_collections_secondary_containers.length ) {
            specific_type_collections.removeClass('twbb-wn-item-not-available');
            //for each specific_type_collections_secondary_containers we can have two from blue button and from + sign
            specific_type_collections_secondary_containers.each(function() {
                if( !jQuery(this).find('.twbb-wn-action-tooltip-items').find(`.twbb-wn-action-tooltip-item[data-id=${ui.attr('data-id')}]`).length) {
                    jQuery(this).find('.twbb-wn-action-tooltip-items').append(tooltip_ui);
                }
            });

        }
        //after further implementation  ui will go to the specific type collection
        ui.remove();
    }
    //add removed item back to proper place
    nav_menu.sortable('refresh');

    //update menu item positions
    twbb_updateMenuItemPositions(nav_menu);

    if( !jQuery('.twbb-website-nav-sidebar-nav-menus-items > .twbb-wn-item').length ) {
        if( !jQuery('.twbb-wn-add-menu-item-blue-button').length ) {
            let template = jQuery('#twbb-wn-add-menu-item-button').html();
            jQuery('.twbb-website-nav-sidebar-nav-menus-items').append(template);
        } else {
            jQuery('.twbb-wn-add-menu-item-blue-button').css('display','block');
        }

        jQuery('.twbb-website-nav-sidebar-navigation-header .twbb-wn-add-item.wn-add-menu-item.twbb-wn-tooltip-parent').addClass('twbb-wn-not-visible');
    }

    analyticsDataPush('Website structure', 'Navigation menu edit', 'Left menu');
}

function twbb_updateMenuItemPositions(nav_menu) {
    let i = 0;
    nav_menu.children().each(function(){
        var item = jQuery(this),
            input = item.find( '.menu-item-data-position' );
        input.val(i);
        i++;
    });
}

function twbb_close_tooltip() {
    let item_actions = jQuery('.twbb-website-nav-sidebar-item__actions');
    if( item_actions.length ) {
        item_actions.removeClass('twbb-wn-visible-tooltip');
    }
    jQuery('.wn-action-tooltip').css('display', 'none');
    jQuery('.twbb-wn-add-item').removeClass('twbb_active');
    jQuery('.twbb-wn-tooltip-parent').removeClass('twbb-opacity-1');
}

function customLinkInputFunction(that) {
    let parent = jQuery(that).closest('.twbb-wn-secondary-container'),
        label_input = parent.find('#wn-custom-link-nav-label').val() ? parent.find('#wn-custom-link-nav-label').val() : 'Menu Item',
        nav_url = parent.find('#wn-custom-link-nav-url'),
        url_input = nav_url.val() ? nav_url.val() : '',
        item_button = parent.find('.twbb-wn-add-custom-menu-item-button');
    if( url_input !== '' ) {
        item_button.removeClass('disabled');
    } else {
        item_button.addClass('disabled');
    }
    item_button.attr('data-title', label_input).attr('data-url', url_input);
}

function twbb_search_init(element) {
    let searchText = element.val().toLowerCase();
    if( searchText !== '' ) {
        element.closest(".twbb-wn-search-wrapper").find(".twbb-wn-clear-search").show();
    } else {
        element.closest(".twbb-wn-search-wrapper").find(".twbb-wn-clear-search").hide();
    }
    let searchResult = 0;
    element.closest(".wn-action-tooltip-container").find('.twbb-wn-action-tooltip-item').each(function() {
        let text = jQuery(this).find('span').first().text().toLowerCase();

        if (text.includes(searchText)) {
            jQuery(this).show();
            searchResult = 1
        } else {
            jQuery(this).hide();
        }
    });
    if( searchResult ) {
        element.closest(".wn-action-tooltip-container").find(".twbb-wn-search-noresult").hide();
    } else {
        element.closest(".wn-action-tooltip-container").find(".twbb-wn-search-noresult").show();
    }
}
